package com.example.gemma

import java.io.BufferedReader
import java.io.InputStreamReader
import java.net.HttpURLConnection
import java.net.URL

class CloudClient(private val baseUrl: String) {
    /** Blocking demo GET endpoint: /generate?prompt=...  Replace with your own. */
    fun generate(prompt: String): String {
        val url = URL("${baseUrl.trimEnd('/')}/generate?prompt=" + java.net.URLEncoder.encode(prompt, "UTF-8"))
        val conn = url.openConnection() as HttpURLConnection
        conn.connectTimeout = 30000
        conn.readTimeout = 30000
        return conn.inputStream.use { input ->
            BufferedReader(InputStreamReader(input)).readText()
        }
    }
}
