package com.example.gemma

import android.app.AlertDialog
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.preference.PreferenceManager

object LicenseGate {
    private const val KEY = "gemma_terms_accepted"

    fun hasAccepted(context: Context): Boolean =
        PreferenceManager.getDefaultSharedPreferences(context).getBoolean(KEY, false)

    fun show(context: Context, onAccepted: () -> Unit) {
        val dlg = AlertDialog.Builder(context)
            .setTitle("Gemma Terms of Use")
            .setMessage("You must accept the Gemma Terms of Use to download and run the model on this device.")
            .setPositiveButton("View Terms") { _, _ ->
                val i = Intent(Intent.ACTION_VIEW, Uri.parse("https://ai.google.dev/gemma/terms"))
                context.startActivity(i)
            }
            .setNeutralButton("I Accept") { d, _ ->
                PreferenceManager.getDefaultSharedPreferences(context)
                    .edit().putBoolean(KEY, true).apply()
                d.dismiss()
                onAccepted()
            }
            .setNegativeButton("Exit", null)
            .create()
        dlg.show()
    }
}
