package com.example.gemma

import android.content.Context
import com.google.mediapipe.tasks.genai.llminference.LlmInference
import com.google.mediapipe.tasks.genai.llminference.LlmInferenceOptions

class LocalGemma(private val context: Context, private val modelPath: String) : AutoCloseable {
    private var llm: LlmInference? = null

    fun load() {
        val options = LlmInferenceOptions.builder()
            .setModelPath(modelPath)
            .setMaxTokens(1024)   // input + output
            .setTopK(40)
            .setTemperature(0.8f)
            .setRandomSeed(101)
            .build()
        llm = LlmInference.createFromOptions(context, options)
    }

    fun generateStream(prompt: String, onToken: (String) -> Unit, onDone: (Boolean) -> Unit) {
        val inst = llm ?: throw IllegalStateException("LLM not loaded")
        val opts = LlmInferenceOptions.builder()
            .setModelPath(modelPath)
            .setMaxTokens(1024)
            .setTopK(40).setTemperature(0.8f).setRandomSeed(101)
            .setResultListener { part, done ->
                onToken(part ?: "")
                if (done) onDone(true)
            }
            .setErrorListener { e ->
                onToken("\n[error: ${'$'}e]"); onDone(false)
            }
            .build()
        val streaming = LlmInference.createFromOptions(context, opts)
        streaming.generateResponseAsync(prompt)
    }

    fun generate(prompt: String): String {
        val inst = llm ?: throw IllegalStateException("LLM not loaded")
        return inst.generateResponse(prompt)
    }

    override fun close() {
        llm?.close()
        llm = null
    }
}
