package com.example.gemma

import android.content.Context
import java.io.File
import java.io.FileOutputStream
import java.net.HttpURLConnection
import java.net.URL

class ModelManager(private val context: Context) {
    companion object {
        // TODO: host the model yourself; do not embed gated URLs/tokens in apps.
        private const val MODEL_URL = "https://YOUR-CDN/gemma3-270m-it-q8.task"
        private const val MODEL_FILE = "gemma3-270m-it-q8.task"
    }

    fun getLocalModelPath(): String? {
        val f = File(context.filesDir, MODEL_FILE)
        return if (f.exists()) f.absolutePath else null
    }

    /** Download model if missing, return absolute path. */
    fun ensureModel(): String {
        val out = File(context.filesDir, MODEL_FILE)
        if (out.exists()) return out.absolutePath
        download(MODEL_URL, out)
        return out.absolutePath
    }

    private fun download(url: String, outFile: File) {
        val conn = URL(url).openConnection() as HttpURLConnection
        conn.connectTimeout = 30000
        conn.readTimeout = 30000
        conn.inputStream.use { input ->
            FileOutputStream(outFile).use { output ->
                val buf = ByteArray(1 shl 16)
                while (true) {
                    val n = input.read(buf)
                    if (n <= 0) break
                    output.write(buf, 0, n)
                }
            }
        }
    }
}
