# Android Starter (MediaPipe LLM Inference)

## 1) Create a new Android Studio project
- Template: **Empty Views Activity** (Kotlin), minSdk ≥ 26.
- Add the dependency in `app/build.gradle`:
```gradle
dependencies {
  implementation 'com.google.mediapipe:tasks-genai:0.10.24'
  implementation 'androidx.appcompat:appcompat:1.6.1'
  implementation 'androidx.core:core-ktx:1.12.0'
  implementation 'com.google.android.material:material:1.11.0'
}
```
- Add permission in `app/src/main/AndroidManifest.xml`:
```xml
<uses-permission android:name="android.permission.INTERNET"/>
```

## 2) Drop the code in `app/src/main/java/com/example/gemma/`
`MainActivity.kt`, `LicenseGate.kt`, `ModelManager.kt`, `LocalGemma.kt`, `CloudClient.kt`, `Router.kt` from this folder.

## 3) Set your model URL
In `ModelManager.kt`, set `MODEL_URL` to your **CDN URL** for `gemma3-270m-it-q8.task`.
Do **not** ship HF access tokens inside apps.

## 4) Run on a real device (GPU preferred)
The MediaPipe LLM Inference API is optimized for **real devices**; emulators are not reliable.

