package com.example.gemma

enum class Routing { AUTO, LOCAL_ONLY, CLOUD_ONLY }

class Router(
    private val local: LocalGemma?,
    private val cloud: CloudClient?,
    private val maxLocalInputTokens: Int = 2048,
) {
    /** Very crude token estimator (spaces as token proxies). Replace with a real tokenizer if needed. */
    private fun estimateTokens(s: String) = (s.length / 4).coerceAtLeast(1)

    fun generate(
        prompt: String,
        routing: Routing,
        onToken: (String) -> Unit,
        onDone: (Boolean, String) -> Unit
    ) {
        when (routing) {
            Routing.LOCAL_ONLY -> {
                local ?: return onDone(false, "local-unavailable")
                local.generateStream(prompt, onToken) { ok -> onDone(ok, "local") }
            }
            Routing.CLOUD_ONLY -> {
                val out = cloud?.generate(prompt) ?: "[cloud unavailable]"
                onToken(out); onDone(true, "cloud")
            }
            Routing.AUTO -> {
                val tokens = estimateTokens(prompt)
                val useLocal = local != null && tokens <= maxLocalInputTokens
                if (useLocal) {
                    local!!.generateStream(prompt, onToken) { ok -> onDone(ok, "local") }
                } else {
                    val out = cloud?.generate(prompt) ?: "[cloud unavailable]"
                    onToken(out); onDone(true, "cloud")
                }
            }
        }
    }
}
