import Foundation
import MediaPipeTasksGenai

@MainActor
final class LocalLlm: ObservableObject {
    private var llm: LlmInference? = nil
    private var modelPath: String? = nil

    func load(modelPath: String) async throws {
        self.modelPath = modelPath
        let opts = LlmInferenceOptions()
        opts.baseOptions.modelPath = modelPath
        opts.maxTokens = 1024
        opts.topk = 40
        opts.temperature = 0.8
        opts.randomSeed = 101
        self.llm = try LlmInference(options: opts)
    }

    func generate(prompt: String) async throws -> String {
        guard let llm else { throw NSError(domain: "LocalLlm", code: 1, userInfo: [NSLocalizedDescriptionKey: "LLM not loaded"]) }
        return try llm.generateResponse(inputText: prompt)
    }

    func generateStream(prompt: String,
                        onToken: @escaping (String) -> Void,
                        onDone: @escaping (Bool) -> Void) async throws {
        guard let modelPath else { throw NSError(domain: "LocalLlm", code: 2, userInfo: [NSLocalizedDescriptionKey: "Model not loaded"]) }
        let opts = LlmInferenceOptions()
        opts.baseOptions.modelPath = modelPath
        opts.maxTokens = 1024
        opts.topk = 40
        opts.temperature = 0.8
        opts.randomSeed = 101
        let streaming = try LlmInference(options: opts)
        let stream = try streaming.generateResponseAsync(inputText: prompt)
        Task {
            do {
                for try await part in stream {
                    onToken(part)
                }
                onDone(true)
            } catch {
                onToken("\n[error: \(error.localizedDescription)]")
                onDone(false)
            }
        }
    }
}
