import Foundation

actor ModelManager {
    static let shared = ModelManager()
    private init() {}

    // TODO: host the model yourself; do not embed gated URLs/tokens in apps.
    private let MODEL_URL = URL(string: "https://YOUR-CDN/gemma3-270m-it-q8.task")!
    private let MODEL_FILE = "gemma3-270m-it-q8.task"

    func localModelPath() -> String? {
        let url = getDocumentsDir().appendingPathComponent(MODEL_FILE)
        return FileManager.default.fileExists(atPath: url.path) ? url.path : nil
    }

    func ensureModel() async throws -> String {
        let url = getDocumentsDir().appendingPathComponent(MODEL_FILE)
        if FileManager.default.fileExists(atPath: url.path) {
            return url.path
        }
        let (tmp, _) = try await URLSession.shared.download(from: MODEL_URL)
        try FileManager.default.moveItem(at: tmp, to: url)
        return url.path
    }

    private func getDocumentsDir() -> URL {
        FileManager.default.urls(for: .documentDirectory, in: .userDomainMask)[0]
    }
}
