# iOS Starter (MediaPipe LLM Inference, SwiftUI)

## 1) Create a new **App** in Xcode (SwiftUI)
- Add CocoaPods to the project and a `Podfile` like below, then `pod install` and open the `.xcworkspace`.

```ruby
target 'Gemma270MStarter' do
  use_frameworks!
  pod 'MediaPipeTasksGenAI'
  pod 'MediaPipeTasksGenAIC'
end
```

## 2) Add these files to your app target
`ContentView.swift`, `LocalLlm.swift`, `ModelManager.swift`, `CloudClient.swift`

## 3) Set your model URL
In `ModelManager.swift`, set `MODEL_URL` to your **CDN URL** for `gemma3-270m-it-q8.task`.

## 4) Run on device (Metal)
The LLM Inference API is optimized for real devices.
