import { FilesetResolver, LlmInference } from "https://cdn.jsdelivr.net/npm/@mediapipe/tasks-genai@latest";
import { TERMS_URL, MODEL_URL, WASM_ROOT, CLOUD_ENDPOINT } from "./config.js";
import { Router } from "./router.js";

const out = document.getElementById("out");
const promptBox = document.getElementById("prompt");
const btnLoad = document.getElementById("load");
const btnSend = document.getElementById("send");
const gate = document.getElementById("gate");
document.getElementById("accept").onclick = () => gate.style.display = "none";

let llm = null;

async function initLocal() {
  const genai = await FilesetResolver.forGenAiTasks(WASM_ROOT);
  llm = await LlmInference.createFromOptions(genai, {
    baseOptions: { modelAssetPath: MODEL_URL },
    maxTokens: 768, topK: 40, temperature: 0.8, randomSeed: 101
  });
}

class Local {
  async generateStream(prompt, onToken) {
    return new Promise((resolve, reject) => {
      llm.generateResponse(prompt, (partial, done) => {
        if (partial) onToken(partial);
        if (done) resolve(true);
      });
    });
  }
}

class Cloud {
  async generate(prompt) {
    const u = new URL(CLOUD_ENDPOINT + "/generate");
    u.searchParams.set("prompt", prompt);
    const res = await fetch(u, { method: "GET" });
    return await res.text();
  }
}

btnLoad.onclick = async () => {
  out.textContent += "\nDownloading / loading model…";
  await initLocal();
  out.textContent += "\nLocal LLM loaded.";
};

btnSend.onclick = async () => {
  const routing = document.querySelector("input[name=route]:checked")?.value ?? "auto";
  const router = new Router(llm ? new Local() : null, new Cloud(), 2048);
  out.textContent += "\n---\n";
  await router.generate(promptBox.value, routing,
    (t) => out.textContent += t,
    (ok, src) => out.textContent += `\n\n[done: ${ok} via ${src}]`);
};
