export class Router {
  constructor(local, cloud, maxLocalInputTokens = 2048) {
    this.local = local;
    this.cloud = cloud;
    this.max = maxLocalInputTokens;
  }
  estimateTokens(s) { return Math.max(1, Math.floor(s.length / 4)); }

  async generate(prompt, routing, onToken, onDone) {
    if (routing === "local") {
      if (!this.local) return onDone(false, "local-unavailable");
      await this.local.generateStream(prompt, onToken); onDone(true, "local"); return;
    }
    if (routing === "cloud") {
      const out = await this.cloud.generate(prompt);
      onToken(out); onDone(true, "cloud"); return;
    }
    // AUTO
    if (this.local && this.estimateTokens(prompt) <= this.max) {
      await this.local.generateStream(prompt, onToken); onDone(true, "local");
    } else {
      const out = await this.cloud.generate(prompt);
      onToken(out); onDone(true, "cloud");
    }
  }
}
